<?php
/**
 * TimeInTransitServiceSummary
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Rating
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Rate
 *
 * The Rating API is used when rating or shopping a shipment. # Reference - <a href=\"https://developer.ups.com/api/reference/rating/business-rules\" target=\"_blank\" rel=\"noopener\">Business Rules</a> - <a href=\"https://developer.ups.com/api/reference/rating/appendix\" target=\"_blank\" rel=\"noopener\">Appendix</a> - <a href=\"https://developer.ups.com/api/reference/rating/error-codes\" target=\"_blank\" rel=\"noopener\">Errors</a> - <a href=\"https://developer.ups.com/api/reference/rating/faq\" target=\"_blank\" rel=\"noopener\">FAQ</a> - <a href=\"https://developer.ups.com/api/reference/rating/best-practices\" target=\"_blank\" rel=\"noopener noreferrer\"> Best Practices</a>  <br/><p>Try out UPS APIs with example requests using Postman. Explore API documentation and sample applications through GitHub.</p>  <a href=\"https://god.gw.postman.com/run-collection/29542085-ac21ef26-eecf-4841-b0b2-737d615b6809?action=collection%2Ffork&source=rip_markdown&collection-url=entityId%3D29542085-ac21ef26-eecf-4841-b0b2-737d615b6809%26entityType%3Dcollection%26workspaceId%3D7e7595f0-4829-4f9a-aee1-75c126b9d417\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://run.pstmn.io/button.svg\" alt=\"Run In Postman\" style=\"width: 128px; height: 32px;\"></a> <a href=\"https://github.com/UPS-API\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://www.ups.com/assets/resources/webcontent/images/gitHubButton.svg\" alt=\"Open in GitHub\" style=\"width: 128px; height: 32px;\"> </a>
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.71
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Rating\Rating;

use \ArrayAccess;
use \UPS\Rating\ObjectSerializer;

/**
 * TimeInTransitServiceSummary Class Doc Comment
 *
 * @category Class
 * @description Container for all available service information.
 * @package  UPS\Rating
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class TimeInTransitServiceSummary implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'TimeInTransit_ServiceSummary';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'service' => '\UPS\Rating\Rating\ServiceSummaryService',
        'guaranteed_indicator' => 'string',
        'disclaimer' => 'string',
        'estimated_arrival' => '\UPS\Rating\Rating\ServiceSummaryEstimatedArrival',
        'saturday_delivery' => 'string',
        'saturday_delivery_disclaimer' => 'string',
        'sunday_delivery' => 'string',
        'sunday_delivery_disclaimer' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'service' => null,
        'guaranteed_indicator' => null,
        'disclaimer' => null,
        'estimated_arrival' => null,
        'saturday_delivery' => null,
        'saturday_delivery_disclaimer' => null,
        'sunday_delivery' => null,
        'sunday_delivery_disclaimer' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'service' => 'Service',
        'guaranteed_indicator' => 'GuaranteedIndicator',
        'disclaimer' => 'Disclaimer',
        'estimated_arrival' => 'EstimatedArrival',
        'saturday_delivery' => 'SaturdayDelivery',
        'saturday_delivery_disclaimer' => 'SaturdayDeliveryDisclaimer',
        'sunday_delivery' => 'SundayDelivery',
        'sunday_delivery_disclaimer' => 'SundayDeliveryDisclaimer'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'service' => 'setService',
        'guaranteed_indicator' => 'setGuaranteedIndicator',
        'disclaimer' => 'setDisclaimer',
        'estimated_arrival' => 'setEstimatedArrival',
        'saturday_delivery' => 'setSaturdayDelivery',
        'saturday_delivery_disclaimer' => 'setSaturdayDeliveryDisclaimer',
        'sunday_delivery' => 'setSundayDelivery',
        'sunday_delivery_disclaimer' => 'setSundayDeliveryDisclaimer'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'service' => 'getService',
        'guaranteed_indicator' => 'getGuaranteedIndicator',
        'disclaimer' => 'getDisclaimer',
        'estimated_arrival' => 'getEstimatedArrival',
        'saturday_delivery' => 'getSaturdayDelivery',
        'saturday_delivery_disclaimer' => 'getSaturdayDeliveryDisclaimer',
        'sunday_delivery' => 'getSundayDelivery',
        'sunday_delivery_disclaimer' => 'getSundayDeliveryDisclaimer'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['service'] = isset($data['service']) ? $data['service'] : null;
        $this->container['guaranteed_indicator'] = isset($data['guaranteed_indicator']) ? $data['guaranteed_indicator'] : null;
        $this->container['disclaimer'] = isset($data['disclaimer']) ? $data['disclaimer'] : null;
        $this->container['estimated_arrival'] = isset($data['estimated_arrival']) ? $data['estimated_arrival'] : null;
        $this->container['saturday_delivery'] = isset($data['saturday_delivery']) ? $data['saturday_delivery'] : null;
        $this->container['saturday_delivery_disclaimer'] = isset($data['saturday_delivery_disclaimer']) ? $data['saturday_delivery_disclaimer'] : null;
        $this->container['sunday_delivery'] = isset($data['sunday_delivery']) ? $data['sunday_delivery'] : null;
        $this->container['sunday_delivery_disclaimer'] = isset($data['sunday_delivery_disclaimer']) ? $data['sunday_delivery_disclaimer'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['service'] === null) {
            $invalidProperties[] = "'service' can't be null";
        }
        if ($this->container['estimated_arrival'] === null) {
            $invalidProperties[] = "'estimated_arrival' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets service
     *
     * @return \UPS\Rating\Rating\ServiceSummaryService
     */
    public function getService()
    {
        return $this->container['service'];
    }

    /**
     * Sets service
     *
     * @param \UPS\Rating\Rating\ServiceSummaryService $service service
     *
     * @return $this
     */
    public function setService($service)
    {
        $this->container['service'] = $service;

        return $this;
    }

    /**
     * Gets guaranteed_indicator
     *
     * @return string
     */
    public function getGuaranteedIndicator()
    {
        return $this->container['guaranteed_indicator'];
    }

    /**
     * Sets guaranteed_indicator
     *
     * @param string $guaranteed_indicator Empty Tag. Indicates whether the service will be guaranteed or not.  Required for International Requests.
     *
     * @return $this
     */
    public function setGuaranteedIndicator($guaranteed_indicator)
    {
        $this->container['guaranteed_indicator'] = $guaranteed_indicator;

        return $this;
    }

    /**
     * Gets disclaimer
     *
     * @return string
     */
    public function getDisclaimer()
    {
        return $this->container['disclaimer'];
    }

    /**
     * Sets disclaimer
     *
     * @param string $disclaimer The Disclaimer is provided based upon the origin and destination country or territory codes provided in the request document. The disclaimer is returned as a conditional statement to the validity of the service being guaranteed. The possible disclaimers that can be returned are available in the Service Guaranteed Disclaimers table.
     *
     * @return $this
     */
    public function setDisclaimer($disclaimer)
    {
        $this->container['disclaimer'] = $disclaimer;

        return $this;
    }

    /**
     * Gets estimated_arrival
     *
     * @return \UPS\Rating\Rating\ServiceSummaryEstimatedArrival
     */
    public function getEstimatedArrival()
    {
        return $this->container['estimated_arrival'];
    }

    /**
     * Sets estimated_arrival
     *
     * @param \UPS\Rating\Rating\ServiceSummaryEstimatedArrival $estimated_arrival estimated_arrival
     *
     * @return $this
     */
    public function setEstimatedArrival($estimated_arrival)
    {
        $this->container['estimated_arrival'] = $estimated_arrival;

        return $this;
    }

    /**
     * Gets saturday_delivery
     *
     * @return string
     */
    public function getSaturdayDelivery()
    {
        return $this->container['saturday_delivery'];
    }

    /**
     * Sets saturday_delivery
     *
     * @param string $saturday_delivery Saturday delivery information for a service. Values are1 - Saturday Delivery Available with additional charges 0 - Saturday Delivery not available or no additional charge, please check Delivery Date to confirm if the Delivery will be SaturdayPlease see Saturday Delivery business rules section for more information.
     *
     * @return $this
     */
    public function setSaturdayDelivery($saturday_delivery)
    {
        $this->container['saturday_delivery'] = $saturday_delivery;

        return $this;
    }

    /**
     * Gets saturday_delivery_disclaimer
     *
     * @return string
     */
    public function getSaturdayDeliveryDisclaimer()
    {
        return $this->container['saturday_delivery_disclaimer'];
    }

    /**
     * Sets saturday_delivery_disclaimer
     *
     * @param string $saturday_delivery_disclaimer Saturday delivery disclaimer message.
     *
     * @return $this
     */
    public function setSaturdayDeliveryDisclaimer($saturday_delivery_disclaimer)
    {
        $this->container['saturday_delivery_disclaimer'] = $saturday_delivery_disclaimer;

        return $this;
    }

    /**
     * Gets sunday_delivery
     *
     * @return string
     */
    public function getSundayDelivery()
    {
        return $this->container['sunday_delivery'];
    }

    /**
     * Sets sunday_delivery
     *
     * @param string $sunday_delivery Sunday delivery information for a service. Values are1 - Sunday Delivery Available with additional charges 0 - Sunday Delivery not available or no additional charge, please check Delivery Date to confirm if the Delivery will be SundayPlease see Saturday Delivery business rules section for more information.  Applies only if SubVersion is greater than or equal to 2007
     *
     * @return $this
     */
    public function setSundayDelivery($sunday_delivery)
    {
        $this->container['sunday_delivery'] = $sunday_delivery;

        return $this;
    }

    /**
     * Gets sunday_delivery_disclaimer
     *
     * @return string
     */
    public function getSundayDeliveryDisclaimer()
    {
        return $this->container['sunday_delivery_disclaimer'];
    }

    /**
     * Sets sunday_delivery_disclaimer
     *
     * @param string $sunday_delivery_disclaimer Sunday delivery disclaimer message.  Applies only if SubVersion is greater than or equal to 2007
     *
     * @return $this
     */
    public function setSundayDeliveryDisclaimer($sunday_delivery_disclaimer)
    {
        $this->container['sunday_delivery_disclaimer'] = $sunday_delivery_disclaimer;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
