<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\IpMessaging\V1;

use Twilio\Options;
use Twilio\Values;

abstract class ServiceOptions
{
    /**
     * @param string  $friendlyName                            The friendly_name
     * @param string  $defaultServiceRoleSid                   The default_service_role_sid
     * @param string  $defaultChannelRoleSid                   The default_channel_role_sid
     * @param string  $defaultChannelCreatorRoleSid            The
     *                                                         default_channel_creator_role_sid
     * @param boolean $readStatusEnabled                       The read_status_enabled
     * @param boolean $reachabilityEnabled                     The reachability_enabled
     * @param integer $typingIndicatorTimeout                  The typing_indicator_timeout
     * @param integer $consumptionReportInterval               The consumption_report_interval
     * @param boolean $notificationsNewMessageEnabled          The
     *                                                         notifications.new_message.enabled
     * @param string  $notificationsNewMessageTemplate         The
     *                                                         notifications.new_message.template
     * @param boolean $notificationsAddedToChannelEnabled      The
     *                                                         notifications.added_to_channel.enabled
     * @param string  $notificationsAddedToChannelTemplate     The
     *                                                         notifications.added_to_channel.template
     * @param boolean $notificationsRemovedFromChannelEnabled  The
     *                                                         notifications.removed_from_channel.enabled
     * @param string  $notificationsRemovedFromChannelTemplate The
     *                                                         notifications.removed_from_channel.template
     * @param boolean $notificationsInvitedToChannelEnabled    The
     *                                                         notifications.invited_to_channel.enabled
     * @param string  $notificationsInvitedToChannelTemplate   The
     *                                                         notifications.invited_to_channel.template
     * @param string  $preWebhookUrl                           The pre_webhook_url
     * @param string  $postWebhookUrl                          The post_webhook_url
     * @param string  $webhookMethod                           The webhook_method
     * @param string  $webhookFilters                          The webhook_filters
     * @param string  $webhooksOnMessageSendUrl                The webhooks.on_message_send.url
     * @param string  $webhooksOnMessageSendMethod             The
     *                                                         webhooks.on_message_send.method
     * @param string  $webhooksOnMessageSendFormat             The
     *                                                         webhooks.on_message_send.format
     * @param string  $webhooksOnMessageUpdateUrl              The webhooks.on_message_update.url
     * @param string  $webhooksOnMessageUpdateMethod           The
     *                                                         webhooks.on_message_update.method
     * @param string  $webhooksOnMessageUpdateFormat           The
     *                                                         webhooks.on_message_update.format
     * @param string  $webhooksOnMessageRemoveUrl              The webhooks.on_message_remove.url
     * @param string  $webhooksOnMessageRemoveMethod           The
     *                                                         webhooks.on_message_remove.method
     * @param string  $webhooksOnMessageRemoveFormat           The
     *                                                         webhooks.on_message_remove.format
     * @param string  $webhooksOnChannelAddUrl                 The webhooks.on_channel_add.url
     * @param string  $webhooksOnChannelAddMethod              The webhooks.on_channel_add.method
     * @param string  $webhooksOnChannelAddFormat              The webhooks.on_channel_add.format
     * @param string  $webhooksOnChannelDestroyUrl             The
     *                                                         webhooks.on_channel_destroy.url
     * @param string  $webhooksOnChannelDestroyMethod          The
     *                                                         webhooks.on_channel_destroy.method
     * @param string  $webhooksOnChannelDestroyFormat          The
     *                                                         webhooks.on_channel_destroy.format
     * @param string  $webhooksOnChannelUpdateUrl              The webhooks.on_channel_update.url
     * @param string  $webhooksOnChannelUpdateMethod           The
     *                                                         webhooks.on_channel_update.method
     * @param string  $webhooksOnChannelUpdateFormat           The
     *                                                         webhooks.on_channel_update.format
     * @param string  $webhooksOnMemberAddUrl                  The webhooks.on_member_add.url
     * @param string  $webhooksOnMemberAddMethod               The webhooks.on_member_add.method
     * @param string  $webhooksOnMemberAddFormat               The webhooks.on_member_add.format
     * @param string  $webhooksOnMemberRemoveUrl               The webhooks.on_member_remove.url
     * @param string  $webhooksOnMemberRemoveMethod            The
     *                                                         webhooks.on_member_remove.method
     * @param string  $webhooksOnMemberRemoveFormat            The
     *                                                         webhooks.on_member_remove.format
     * @param string  $webhooksOnMessageSentUrl                The webhooks.on_message_sent.url
     * @param string  $webhooksOnMessageSentMethod             The
     *                                                         webhooks.on_message_sent.method
     * @param string  $webhooksOnMessageSentFormat             The
     *                                                         webhooks.on_message_sent.format
     * @param string  $webhooksOnMessageUpdatedUrl             The
     *                                                         webhooks.on_message_updated.url
     * @param string  $webhooksOnMessageUpdatedMethod          The
     *                                                         webhooks.on_message_updated.method
     * @param string  $webhooksOnMessageUpdatedFormat          The
     *                                                         webhooks.on_message_updated.format
     * @param string  $webhooksOnMessageRemovedUrl             The
     *                                                         webhooks.on_message_removed.url
     * @param string  $webhooksOnMessageRemovedMethod          The
     *                                                         webhooks.on_message_removed.method
     * @param string  $webhooksOnMessageRemovedFormat          The
     *                                                         webhooks.on_message_removed.format
     * @param string  $webhooksOnChannelAddedUrl               The webhooks.on_channel_added.url
     * @param string  $webhooksOnChannelAddedMethod            The
     *                                                         webhooks.on_channel_added.method
     * @param string  $webhooksOnChannelAddedFormat            The
     *                                                         webhooks.on_channel_added.format
     * @param string  $webhooksOnChannelDestroyedUrl           The
     *                                                         webhooks.on_channel_destroyed.url
     * @param string  $webhooksOnChannelDestroyedMethod        The
     *                                                         webhooks.on_channel_destroyed.method
     * @param string  $webhooksOnChannelDestroyedFormat        The
     *                                                         webhooks.on_channel_destroyed.format
     * @param string  $webhooksOnChannelUpdatedUrl             The
     *                                                         webhooks.on_channel_updated.url
     * @param string  $webhooksOnChannelUpdatedMethod          The
     *                                                         webhooks.on_channel_updated.method
     * @param string  $webhooksOnChannelUpdatedFormat          The
     *                                                         webhooks.on_channel_updated.format
     * @param string  $webhooksOnMemberAddedUrl                The webhooks.on_member_added.url
     * @param string  $webhooksOnMemberAddedMethod             The
     *                                                         webhooks.on_member_added.method
     * @param string  $webhooksOnMemberAddedFormat             The
     *                                                         webhooks.on_member_added.format
     * @param string  $webhooksOnMemberRemovedUrl              The webhooks.on_member_removed.url
     * @param string  $webhooksOnMemberRemovedMethod           The
     *                                                         webhooks.on_member_removed.method
     * @param string  $webhooksOnMemberRemovedFormat           The
     *                                                         webhooks.on_member_removed.format
     * @param integer $limitsChannelMembers                    The limits.channel_members
     * @param integer $limitsUserChannels                      The limits.user_channels
     *
     * @return UpdateServiceOptions Options builder
     */
    public static function update(
        $friendlyName = Values::NONE,
        $defaultServiceRoleSid = Values::NONE,
        $defaultChannelRoleSid = Values::NONE,
        $defaultChannelCreatorRoleSid = Values::NONE,
        $readStatusEnabled = Values::NONE,
        $reachabilityEnabled = Values::NONE,
        $typingIndicatorTimeout = Values::NONE,
        $consumptionReportInterval = Values::NONE,
        $notificationsNewMessageEnabled = Values::NONE,
        $notificationsNewMessageTemplate = Values::NONE,
        $notificationsAddedToChannelEnabled = Values::NONE,
        $notificationsAddedToChannelTemplate = Values::NONE,
        $notificationsRemovedFromChannelEnabled = Values::NONE,
        $notificationsRemovedFromChannelTemplate = Values::NONE,
        $notificationsInvitedToChannelEnabled = Values::NONE,
        $notificationsInvitedToChannelTemplate = Values::NONE,
        $preWebhookUrl = Values::NONE,
        $postWebhookUrl = Values::NONE,
        $webhookMethod = Values::NONE,
        $webhookFilters = Values::NONE,
        $webhooksOnMessageSendUrl = Values::NONE,
        $webhooksOnMessageSendMethod = Values::NONE,
        $webhooksOnMessageSendFormat = Values::NONE,
        $webhooksOnMessageUpdateUrl = Values::NONE,
        $webhooksOnMessageUpdateMethod = Values::NONE,
        $webhooksOnMessageUpdateFormat = Values::NONE,
        $webhooksOnMessageRemoveUrl = Values::NONE,
        $webhooksOnMessageRemoveMethod = Values::NONE,
        $webhooksOnMessageRemoveFormat = Values::NONE,
        $webhooksOnChannelAddUrl = Values::NONE,
        $webhooksOnChannelAddMethod = Values::NONE,
        $webhooksOnChannelAddFormat = Values::NONE,
        $webhooksOnChannelDestroyUrl = Values::NONE,
        $webhooksOnChannelDestroyMethod = Values::NONE,
        $webhooksOnChannelDestroyFormat = Values::NONE,
        $webhooksOnChannelUpdateUrl = Values::NONE,
        $webhooksOnChannelUpdateMethod = Values::NONE,
        $webhooksOnChannelUpdateFormat = Values::NONE,
        $webhooksOnMemberAddUrl = Values::NONE,
        $webhooksOnMemberAddMethod = Values::NONE,
        $webhooksOnMemberAddFormat = Values::NONE,
        $webhooksOnMemberRemoveUrl = Values::NONE,
        $webhooksOnMemberRemoveMethod = Values::NONE,
        $webhooksOnMemberRemoveFormat = Values::NONE,
        $webhooksOnMessageSentUrl = Values::NONE,
        $webhooksOnMessageSentMethod = Values::NONE,
        $webhooksOnMessageSentFormat = Values::NONE,
        $webhooksOnMessageUpdatedUrl = Values::NONE,
        $webhooksOnMessageUpdatedMethod = Values::NONE,
        $webhooksOnMessageUpdatedFormat = Values::NONE,
        $webhooksOnMessageRemovedUrl = Values::NONE,
        $webhooksOnMessageRemovedMethod = Values::NONE,
        $webhooksOnMessageRemovedFormat = Values::NONE,
        $webhooksOnChannelAddedUrl = Values::NONE,
        $webhooksOnChannelAddedMethod = Values::NONE,
        $webhooksOnChannelAddedFormat = Values::NONE,
        $webhooksOnChannelDestroyedUrl = Values::NONE,
        $webhooksOnChannelDestroyedMethod = Values::NONE,
        $webhooksOnChannelDestroyedFormat = Values::NONE,
        $webhooksOnChannelUpdatedUrl = Values::NONE,
        $webhooksOnChannelUpdatedMethod = Values::NONE,
        $webhooksOnChannelUpdatedFormat = Values::NONE,
        $webhooksOnMemberAddedUrl = Values::NONE,
        $webhooksOnMemberAddedMethod = Values::NONE,
        $webhooksOnMemberAddedFormat = Values::NONE,
        $webhooksOnMemberRemovedUrl = Values::NONE,
        $webhooksOnMemberRemovedMethod = Values::NONE,
        $webhooksOnMemberRemovedFormat = Values::NONE,
        $limitsChannelMembers = Values::NONE,
        $limitsUserChannels = Values::NONE
    ) {
        return new UpdateServiceOptions($friendlyName, $defaultServiceRoleSid, $defaultChannelRoleSid, $defaultChannelCreatorRoleSid, $readStatusEnabled, $reachabilityEnabled, $typingIndicatorTimeout, $consumptionReportInterval, $notificationsNewMessageEnabled,
            $notificationsNewMessageTemplate, $notificationsAddedToChannelEnabled, $notificationsAddedToChannelTemplate, $notificationsRemovedFromChannelEnabled, $notificationsRemovedFromChannelTemplate, $notificationsInvitedToChannelEnabled,
            $notificationsInvitedToChannelTemplate, $preWebhookUrl, $postWebhookUrl, $webhookMethod, $webhookFilters, $webhooksOnMessageSendUrl, $webhooksOnMessageSendMethod, $webhooksOnMessageSendFormat, $webhooksOnMessageUpdateUrl, $webhooksOnMessageUpdateMethod,
            $webhooksOnMessageUpdateFormat, $webhooksOnMessageRemoveUrl, $webhooksOnMessageRemoveMethod, $webhooksOnMessageRemoveFormat, $webhooksOnChannelAddUrl, $webhooksOnChannelAddMethod, $webhooksOnChannelAddFormat, $webhooksOnChannelDestroyUrl,
            $webhooksOnChannelDestroyMethod, $webhooksOnChannelDestroyFormat, $webhooksOnChannelUpdateUrl, $webhooksOnChannelUpdateMethod, $webhooksOnChannelUpdateFormat, $webhooksOnMemberAddUrl, $webhooksOnMemberAddMethod, $webhooksOnMemberAddFormat, $webhooksOnMemberRemoveUrl,
            $webhooksOnMemberRemoveMethod, $webhooksOnMemberRemoveFormat, $webhooksOnMessageSentUrl, $webhooksOnMessageSentMethod, $webhooksOnMessageSentFormat, $webhooksOnMessageUpdatedUrl, $webhooksOnMessageUpdatedMethod, $webhooksOnMessageUpdatedFormat,
            $webhooksOnMessageRemovedUrl, $webhooksOnMessageRemovedMethod, $webhooksOnMessageRemovedFormat, $webhooksOnChannelAddedUrl, $webhooksOnChannelAddedMethod, $webhooksOnChannelAddedFormat, $webhooksOnChannelDestroyedUrl, $webhooksOnChannelDestroyedMethod,
            $webhooksOnChannelDestroyedFormat, $webhooksOnChannelUpdatedUrl, $webhooksOnChannelUpdatedMethod, $webhooksOnChannelUpdatedFormat, $webhooksOnMemberAddedUrl, $webhooksOnMemberAddedMethod, $webhooksOnMemberAddedFormat, $webhooksOnMemberRemovedUrl,
            $webhooksOnMemberRemovedMethod, $webhooksOnMemberRemovedFormat, $limitsChannelMembers, $limitsUserChannels);
    }
}

class UpdateServiceOptions extends Options
{
    /**
     * @param string  $friendlyName                            The friendly_name
     * @param string  $defaultServiceRoleSid                   The default_service_role_sid
     * @param string  $defaultChannelRoleSid                   The default_channel_role_sid
     * @param string  $defaultChannelCreatorRoleSid            The
     *                                                         default_channel_creator_role_sid
     * @param boolean $readStatusEnabled                       The read_status_enabled
     * @param boolean $reachabilityEnabled                     The reachability_enabled
     * @param integer $typingIndicatorTimeout                  The typing_indicator_timeout
     * @param integer $consumptionReportInterval               The consumption_report_interval
     * @param boolean $notificationsNewMessageEnabled          The
     *                                                         notifications.new_message.enabled
     * @param string  $notificationsNewMessageTemplate         The
     *                                                         notifications.new_message.template
     * @param boolean $notificationsAddedToChannelEnabled      The
     *                                                         notifications.added_to_channel.enabled
     * @param string  $notificationsAddedToChannelTemplate     The
     *                                                         notifications.added_to_channel.template
     * @param boolean $notificationsRemovedFromChannelEnabled  The
     *                                                         notifications.removed_from_channel.enabled
     * @param string  $notificationsRemovedFromChannelTemplate The
     *                                                         notifications.removed_from_channel.template
     * @param boolean $notificationsInvitedToChannelEnabled    The
     *                                                         notifications.invited_to_channel.enabled
     * @param string  $notificationsInvitedToChannelTemplate   The
     *                                                         notifications.invited_to_channel.template
     * @param string  $preWebhookUrl                           The pre_webhook_url
     * @param string  $postWebhookUrl                          The post_webhook_url
     * @param string  $webhookMethod                           The webhook_method
     * @param string  $webhookFilters                          The webhook_filters
     * @param string  $webhooksOnMessageSendUrl                The webhooks.on_message_send.url
     * @param string  $webhooksOnMessageSendMethod             The
     *                                                         webhooks.on_message_send.method
     * @param string  $webhooksOnMessageSendFormat             The
     *                                                         webhooks.on_message_send.format
     * @param string  $webhooksOnMessageUpdateUrl              The webhooks.on_message_update.url
     * @param string  $webhooksOnMessageUpdateMethod           The
     *                                                         webhooks.on_message_update.method
     * @param string  $webhooksOnMessageUpdateFormat           The
     *                                                         webhooks.on_message_update.format
     * @param string  $webhooksOnMessageRemoveUrl              The webhooks.on_message_remove.url
     * @param string  $webhooksOnMessageRemoveMethod           The
     *                                                         webhooks.on_message_remove.method
     * @param string  $webhooksOnMessageRemoveFormat           The
     *                                                         webhooks.on_message_remove.format
     * @param string  $webhooksOnChannelAddUrl                 The webhooks.on_channel_add.url
     * @param string  $webhooksOnChannelAddMethod              The webhooks.on_channel_add.method
     * @param string  $webhooksOnChannelAddFormat              The webhooks.on_channel_add.format
     * @param string  $webhooksOnChannelDestroyUrl             The
     *                                                         webhooks.on_channel_destroy.url
     * @param string  $webhooksOnChannelDestroyMethod          The
     *                                                         webhooks.on_channel_destroy.method
     * @param string  $webhooksOnChannelDestroyFormat          The
     *                                                         webhooks.on_channel_destroy.format
     * @param string  $webhooksOnChannelUpdateUrl              The webhooks.on_channel_update.url
     * @param string  $webhooksOnChannelUpdateMethod           The
     *                                                         webhooks.on_channel_update.method
     * @param string  $webhooksOnChannelUpdateFormat           The
     *                                                         webhooks.on_channel_update.format
     * @param string  $webhooksOnMemberAddUrl                  The webhooks.on_member_add.url
     * @param string  $webhooksOnMemberAddMethod               The webhooks.on_member_add.method
     * @param string  $webhooksOnMemberAddFormat               The webhooks.on_member_add.format
     * @param string  $webhooksOnMemberRemoveUrl               The webhooks.on_member_remove.url
     * @param string  $webhooksOnMemberRemoveMethod            The
     *                                                         webhooks.on_member_remove.method
     * @param string  $webhooksOnMemberRemoveFormat            The
     *                                                         webhooks.on_member_remove.format
     * @param string  $webhooksOnMessageSentUrl                The webhooks.on_message_sent.url
     * @param string  $webhooksOnMessageSentMethod             The
     *                                                         webhooks.on_message_sent.method
     * @param string  $webhooksOnMessageSentFormat             The
     *                                                         webhooks.on_message_sent.format
     * @param string  $webhooksOnMessageUpdatedUrl             The
     *                                                         webhooks.on_message_updated.url
     * @param string  $webhooksOnMessageUpdatedMethod          The
     *                                                         webhooks.on_message_updated.method
     * @param string  $webhooksOnMessageUpdatedFormat          The
     *                                                         webhooks.on_message_updated.format
     * @param string  $webhooksOnMessageRemovedUrl             The
     *                                                         webhooks.on_message_removed.url
     * @param string  $webhooksOnMessageRemovedMethod          The
     *                                                         webhooks.on_message_removed.method
     * @param string  $webhooksOnMessageRemovedFormat          The
     *                                                         webhooks.on_message_removed.format
     * @param string  $webhooksOnChannelAddedUrl               The webhooks.on_channel_added.url
     * @param string  $webhooksOnChannelAddedMethod            The
     *                                                         webhooks.on_channel_added.method
     * @param string  $webhooksOnChannelAddedFormat            The
     *                                                         webhooks.on_channel_added.format
     * @param string  $webhooksOnChannelDestroyedUrl           The
     *                                                         webhooks.on_channel_destroyed.url
     * @param string  $webhooksOnChannelDestroyedMethod        The
     *                                                         webhooks.on_channel_destroyed.method
     * @param string  $webhooksOnChannelDestroyedFormat        The
     *                                                         webhooks.on_channel_destroyed.format
     * @param string  $webhooksOnChannelUpdatedUrl             The
     *                                                         webhooks.on_channel_updated.url
     * @param string  $webhooksOnChannelUpdatedMethod          The
     *                                                         webhooks.on_channel_updated.method
     * @param string  $webhooksOnChannelUpdatedFormat          The
     *                                                         webhooks.on_channel_updated.format
     * @param string  $webhooksOnMemberAddedUrl                The webhooks.on_member_added.url
     * @param string  $webhooksOnMemberAddedMethod             The
     *                                                         webhooks.on_member_added.method
     * @param string  $webhooksOnMemberAddedFormat             The
     *                                                         webhooks.on_member_added.format
     * @param string  $webhooksOnMemberRemovedUrl              The webhooks.on_member_removed.url
     * @param string  $webhooksOnMemberRemovedMethod           The
     *                                                         webhooks.on_member_removed.method
     * @param string  $webhooksOnMemberRemovedFormat           The
     *                                                         webhooks.on_member_removed.format
     * @param integer $limitsChannelMembers                    The limits.channel_members
     * @param integer $limitsUserChannels                      The limits.user_channels
     */
    public function __construct(
        $friendlyName = Values::NONE,
        $defaultServiceRoleSid = Values::NONE,
        $defaultChannelRoleSid = Values::NONE,
        $defaultChannelCreatorRoleSid = Values::NONE,
        $readStatusEnabled = Values::NONE,
        $reachabilityEnabled = Values::NONE,
        $typingIndicatorTimeout = Values::NONE,
        $consumptionReportInterval = Values::NONE,
        $notificationsNewMessageEnabled = Values::NONE,
        $notificationsNewMessageTemplate = Values::NONE,
        $notificationsAddedToChannelEnabled = Values::NONE,
        $notificationsAddedToChannelTemplate = Values::NONE,
        $notificationsRemovedFromChannelEnabled = Values::NONE,
        $notificationsRemovedFromChannelTemplate = Values::NONE,
        $notificationsInvitedToChannelEnabled = Values::NONE,
        $notificationsInvitedToChannelTemplate = Values::NONE,
        $preWebhookUrl = Values::NONE,
        $postWebhookUrl = Values::NONE,
        $webhookMethod = Values::NONE,
        $webhookFilters = Values::NONE,
        $webhooksOnMessageSendUrl = Values::NONE,
        $webhooksOnMessageSendMethod = Values::NONE,
        $webhooksOnMessageSendFormat = Values::NONE,
        $webhooksOnMessageUpdateUrl = Values::NONE,
        $webhooksOnMessageUpdateMethod = Values::NONE,
        $webhooksOnMessageUpdateFormat = Values::NONE,
        $webhooksOnMessageRemoveUrl = Values::NONE,
        $webhooksOnMessageRemoveMethod = Values::NONE,
        $webhooksOnMessageRemoveFormat = Values::NONE,
        $webhooksOnChannelAddUrl = Values::NONE,
        $webhooksOnChannelAddMethod = Values::NONE,
        $webhooksOnChannelAddFormat = Values::NONE,
        $webhooksOnChannelDestroyUrl = Values::NONE,
        $webhooksOnChannelDestroyMethod = Values::NONE,
        $webhooksOnChannelDestroyFormat = Values::NONE,
        $webhooksOnChannelUpdateUrl = Values::NONE,
        $webhooksOnChannelUpdateMethod = Values::NONE,
        $webhooksOnChannelUpdateFormat = Values::NONE,
        $webhooksOnMemberAddUrl = Values::NONE,
        $webhooksOnMemberAddMethod = Values::NONE,
        $webhooksOnMemberAddFormat = Values::NONE,
        $webhooksOnMemberRemoveUrl = Values::NONE,
        $webhooksOnMemberRemoveMethod = Values::NONE,
        $webhooksOnMemberRemoveFormat = Values::NONE,
        $webhooksOnMessageSentUrl = Values::NONE,
        $webhooksOnMessageSentMethod = Values::NONE,
        $webhooksOnMessageSentFormat = Values::NONE,
        $webhooksOnMessageUpdatedUrl = Values::NONE,
        $webhooksOnMessageUpdatedMethod = Values::NONE,
        $webhooksOnMessageUpdatedFormat = Values::NONE,
        $webhooksOnMessageRemovedUrl = Values::NONE,
        $webhooksOnMessageRemovedMethod = Values::NONE,
        $webhooksOnMessageRemovedFormat = Values::NONE,
        $webhooksOnChannelAddedUrl = Values::NONE,
        $webhooksOnChannelAddedMethod = Values::NONE,
        $webhooksOnChannelAddedFormat = Values::NONE,
        $webhooksOnChannelDestroyedUrl = Values::NONE,
        $webhooksOnChannelDestroyedMethod = Values::NONE,
        $webhooksOnChannelDestroyedFormat = Values::NONE,
        $webhooksOnChannelUpdatedUrl = Values::NONE,
        $webhooksOnChannelUpdatedMethod = Values::NONE,
        $webhooksOnChannelUpdatedFormat = Values::NONE,
        $webhooksOnMemberAddedUrl = Values::NONE,
        $webhooksOnMemberAddedMethod = Values::NONE,
        $webhooksOnMemberAddedFormat = Values::NONE,
        $webhooksOnMemberRemovedUrl = Values::NONE,
        $webhooksOnMemberRemovedMethod = Values::NONE,
        $webhooksOnMemberRemovedFormat = Values::NONE,
        $limitsChannelMembers = Values::NONE,
        $limitsUserChannels = Values::NONE
    ) {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['defaultServiceRoleSid'] = $defaultServiceRoleSid;
        $this->options['defaultChannelRoleSid'] = $defaultChannelRoleSid;
        $this->options['defaultChannelCreatorRoleSid'] = $defaultChannelCreatorRoleSid;
        $this->options['readStatusEnabled'] = $readStatusEnabled;
        $this->options['reachabilityEnabled'] = $reachabilityEnabled;
        $this->options['typingIndicatorTimeout'] = $typingIndicatorTimeout;
        $this->options['consumptionReportInterval'] = $consumptionReportInterval;
        $this->options['notificationsNewMessageEnabled'] = $notificationsNewMessageEnabled;
        $this->options['notificationsNewMessageTemplate'] = $notificationsNewMessageTemplate;
        $this->options['notificationsAddedToChannelEnabled'] = $notificationsAddedToChannelEnabled;
        $this->options['notificationsAddedToChannelTemplate'] = $notificationsAddedToChannelTemplate;
        $this->options['notificationsRemovedFromChannelEnabled'] = $notificationsRemovedFromChannelEnabled;
        $this->options['notificationsRemovedFromChannelTemplate'] = $notificationsRemovedFromChannelTemplate;
        $this->options['notificationsInvitedToChannelEnabled'] = $notificationsInvitedToChannelEnabled;
        $this->options['notificationsInvitedToChannelTemplate'] = $notificationsInvitedToChannelTemplate;
        $this->options['preWebhookUrl'] = $preWebhookUrl;
        $this->options['postWebhookUrl'] = $postWebhookUrl;
        $this->options['webhookMethod'] = $webhookMethod;
        $this->options['webhookFilters'] = $webhookFilters;
        $this->options['webhooksOnMessageSendUrl'] = $webhooksOnMessageSendUrl;
        $this->options['webhooksOnMessageSendMethod'] = $webhooksOnMessageSendMethod;
        $this->options['webhooksOnMessageSendFormat'] = $webhooksOnMessageSendFormat;
        $this->options['webhooksOnMessageUpdateUrl'] = $webhooksOnMessageUpdateUrl;
        $this->options['webhooksOnMessageUpdateMethod'] = $webhooksOnMessageUpdateMethod;
        $this->options['webhooksOnMessageUpdateFormat'] = $webhooksOnMessageUpdateFormat;
        $this->options['webhooksOnMessageRemoveUrl'] = $webhooksOnMessageRemoveUrl;
        $this->options['webhooksOnMessageRemoveMethod'] = $webhooksOnMessageRemoveMethod;
        $this->options['webhooksOnMessageRemoveFormat'] = $webhooksOnMessageRemoveFormat;
        $this->options['webhooksOnChannelAddUrl'] = $webhooksOnChannelAddUrl;
        $this->options['webhooksOnChannelAddMethod'] = $webhooksOnChannelAddMethod;
        $this->options['webhooksOnChannelAddFormat'] = $webhooksOnChannelAddFormat;
        $this->options['webhooksOnChannelDestroyUrl'] = $webhooksOnChannelDestroyUrl;
        $this->options['webhooksOnChannelDestroyMethod'] = $webhooksOnChannelDestroyMethod;
        $this->options['webhooksOnChannelDestroyFormat'] = $webhooksOnChannelDestroyFormat;
        $this->options['webhooksOnChannelUpdateUrl'] = $webhooksOnChannelUpdateUrl;
        $this->options['webhooksOnChannelUpdateMethod'] = $webhooksOnChannelUpdateMethod;
        $this->options['webhooksOnChannelUpdateFormat'] = $webhooksOnChannelUpdateFormat;
        $this->options['webhooksOnMemberAddUrl'] = $webhooksOnMemberAddUrl;
        $this->options['webhooksOnMemberAddMethod'] = $webhooksOnMemberAddMethod;
        $this->options['webhooksOnMemberAddFormat'] = $webhooksOnMemberAddFormat;
        $this->options['webhooksOnMemberRemoveUrl'] = $webhooksOnMemberRemoveUrl;
        $this->options['webhooksOnMemberRemoveMethod'] = $webhooksOnMemberRemoveMethod;
        $this->options['webhooksOnMemberRemoveFormat'] = $webhooksOnMemberRemoveFormat;
        $this->options['webhooksOnMessageSentUrl'] = $webhooksOnMessageSentUrl;
        $this->options['webhooksOnMessageSentMethod'] = $webhooksOnMessageSentMethod;
        $this->options['webhooksOnMessageSentFormat'] = $webhooksOnMessageSentFormat;
        $this->options['webhooksOnMessageUpdatedUrl'] = $webhooksOnMessageUpdatedUrl;
        $this->options['webhooksOnMessageUpdatedMethod'] = $webhooksOnMessageUpdatedMethod;
        $this->options['webhooksOnMessageUpdatedFormat'] = $webhooksOnMessageUpdatedFormat;
        $this->options['webhooksOnMessageRemovedUrl'] = $webhooksOnMessageRemovedUrl;
        $this->options['webhooksOnMessageRemovedMethod'] = $webhooksOnMessageRemovedMethod;
        $this->options['webhooksOnMessageRemovedFormat'] = $webhooksOnMessageRemovedFormat;
        $this->options['webhooksOnChannelAddedUrl'] = $webhooksOnChannelAddedUrl;
        $this->options['webhooksOnChannelAddedMethod'] = $webhooksOnChannelAddedMethod;
        $this->options['webhooksOnChannelAddedFormat'] = $webhooksOnChannelAddedFormat;
        $this->options['webhooksOnChannelDestroyedUrl'] = $webhooksOnChannelDestroyedUrl;
        $this->options['webhooksOnChannelDestroyedMethod'] = $webhooksOnChannelDestroyedMethod;
        $this->options['webhooksOnChannelDestroyedFormat'] = $webhooksOnChannelDestroyedFormat;
        $this->options['webhooksOnChannelUpdatedUrl'] = $webhooksOnChannelUpdatedUrl;
        $this->options['webhooksOnChannelUpdatedMethod'] = $webhooksOnChannelUpdatedMethod;
        $this->options['webhooksOnChannelUpdatedFormat'] = $webhooksOnChannelUpdatedFormat;
        $this->options['webhooksOnMemberAddedUrl'] = $webhooksOnMemberAddedUrl;
        $this->options['webhooksOnMemberAddedMethod'] = $webhooksOnMemberAddedMethod;
        $this->options['webhooksOnMemberAddedFormat'] = $webhooksOnMemberAddedFormat;
        $this->options['webhooksOnMemberRemovedUrl'] = $webhooksOnMemberRemovedUrl;
        $this->options['webhooksOnMemberRemovedMethod'] = $webhooksOnMemberRemovedMethod;
        $this->options['webhooksOnMemberRemovedFormat'] = $webhooksOnMemberRemovedFormat;
        $this->options['limitsChannelMembers'] = $limitsChannelMembers;
        $this->options['limitsUserChannels'] = $limitsUserChannels;
    }

    /**
     * The friendly_name
     *
     * @param string $friendlyName The friendly_name
     *
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName)
    {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The default_service_role_sid
     *
     * @param string $defaultServiceRoleSid The default_service_role_sid
     *
     * @return $this Fluent Builder
     */
    public function setDefaultServiceRoleSid($defaultServiceRoleSid)
    {
        $this->options['defaultServiceRoleSid'] = $defaultServiceRoleSid;
        return $this;
    }

    /**
     * The default_channel_role_sid
     *
     * @param string $defaultChannelRoleSid The default_channel_role_sid
     *
     * @return $this Fluent Builder
     */
    public function setDefaultChannelRoleSid($defaultChannelRoleSid)
    {
        $this->options['defaultChannelRoleSid'] = $defaultChannelRoleSid;
        return $this;
    }

    /**
     * The default_channel_creator_role_sid
     *
     * @param string $defaultChannelCreatorRoleSid The
     *                                             default_channel_creator_role_sid
     *
     * @return $this Fluent Builder
     */
    public function setDefaultChannelCreatorRoleSid($defaultChannelCreatorRoleSid)
    {
        $this->options['defaultChannelCreatorRoleSid'] = $defaultChannelCreatorRoleSid;
        return $this;
    }

    /**
     * The read_status_enabled
     *
     * @param boolean $readStatusEnabled The read_status_enabled
     *
     * @return $this Fluent Builder
     */
    public function setReadStatusEnabled($readStatusEnabled)
    {
        $this->options['readStatusEnabled'] = $readStatusEnabled;
        return $this;
    }

    /**
     * The reachability_enabled
     *
     * @param boolean $reachabilityEnabled The reachability_enabled
     *
     * @return $this Fluent Builder
     */
    public function setReachabilityEnabled($reachabilityEnabled)
    {
        $this->options['reachabilityEnabled'] = $reachabilityEnabled;
        return $this;
    }

    /**
     * The typing_indicator_timeout
     *
     * @param integer $typingIndicatorTimeout The typing_indicator_timeout
     *
     * @return $this Fluent Builder
     */
    public function setTypingIndicatorTimeout($typingIndicatorTimeout)
    {
        $this->options['typingIndicatorTimeout'] = $typingIndicatorTimeout;
        return $this;
    }

    /**
     * The consumption_report_interval
     *
     * @param integer $consumptionReportInterval The consumption_report_interval
     *
     * @return $this Fluent Builder
     */
    public function setConsumptionReportInterval($consumptionReportInterval)
    {
        $this->options['consumptionReportInterval'] = $consumptionReportInterval;
        return $this;
    }

    /**
     * The notifications.new_message.enabled
     *
     * @param boolean $notificationsNewMessageEnabled The
     *                                                notifications.new_message.enabled
     *
     * @return $this Fluent Builder
     */
    public function setNotificationsNewMessageEnabled($notificationsNewMessageEnabled)
    {
        $this->options['notificationsNewMessageEnabled'] = $notificationsNewMessageEnabled;
        return $this;
    }

    /**
     * The notifications.new_message.template
     *
     * @param string $notificationsNewMessageTemplate The
     *                                                notifications.new_message.template
     *
     * @return $this Fluent Builder
     */
    public function setNotificationsNewMessageTemplate($notificationsNewMessageTemplate)
    {
        $this->options['notificationsNewMessageTemplate'] = $notificationsNewMessageTemplate;
        return $this;
    }

    /**
     * The notifications.added_to_channel.enabled
     *
     * @param boolean $notificationsAddedToChannelEnabled The
     *                                                    notifications.added_to_channel.enabled
     *
     * @return $this Fluent Builder
     */
    public function setNotificationsAddedToChannelEnabled($notificationsAddedToChannelEnabled)
    {
        $this->options['notificationsAddedToChannelEnabled'] = $notificationsAddedToChannelEnabled;
        return $this;
    }

    /**
     * The notifications.added_to_channel.template
     *
     * @param string $notificationsAddedToChannelTemplate The
     *                                                    notifications.added_to_channel.template
     *
     * @return $this Fluent Builder
     */
    public function setNotificationsAddedToChannelTemplate($notificationsAddedToChannelTemplate)
    {
        $this->options['notificationsAddedToChannelTemplate'] = $notificationsAddedToChannelTemplate;
        return $this;
    }

    /**
     * The notifications.removed_from_channel.enabled
     *
     * @param boolean $notificationsRemovedFromChannelEnabled The
     *                                                        notifications.removed_from_channel.enabled
     *
     * @return $this Fluent Builder
     */
    public function setNotificationsRemovedFromChannelEnabled($notificationsRemovedFromChannelEnabled)
    {
        $this->options['notificationsRemovedFromChannelEnabled'] = $notificationsRemovedFromChannelEnabled;
        return $this;
    }

    /**
     * The notifications.removed_from_channel.template
     *
     * @param string $notificationsRemovedFromChannelTemplate The
     *                                                        notifications.removed_from_channel.template
     *
     * @return $this Fluent Builder
     */
    public function setNotificationsRemovedFromChannelTemplate($notificationsRemovedFromChannelTemplate)
    {
        $this->options['notificationsRemovedFromChannelTemplate'] = $notificationsRemovedFromChannelTemplate;
        return $this;
    }

    /**
     * The notifications.invited_to_channel.enabled
     *
     * @param boolean $notificationsInvitedToChannelEnabled The
     *                                                      notifications.invited_to_channel.enabled
     *
     * @return $this Fluent Builder
     */
    public function setNotificationsInvitedToChannelEnabled($notificationsInvitedToChannelEnabled)
    {
        $this->options['notificationsInvitedToChannelEnabled'] = $notificationsInvitedToChannelEnabled;
        return $this;
    }

    /**
     * The notifications.invited_to_channel.template
     *
     * @param string $notificationsInvitedToChannelTemplate The
     *                                                      notifications.invited_to_channel.template
     *
     * @return $this Fluent Builder
     */
    public function setNotificationsInvitedToChannelTemplate($notificationsInvitedToChannelTemplate)
    {
        $this->options['notificationsInvitedToChannelTemplate'] = $notificationsInvitedToChannelTemplate;
        return $this;
    }

    /**
     * The pre_webhook_url
     *
     * @param string $preWebhookUrl The pre_webhook_url
     *
     * @return $this Fluent Builder
     */
    public function setPreWebhookUrl($preWebhookUrl)
    {
        $this->options['preWebhookUrl'] = $preWebhookUrl;
        return $this;
    }

    /**
     * The post_webhook_url
     *
     * @param string $postWebhookUrl The post_webhook_url
     *
     * @return $this Fluent Builder
     */
    public function setPostWebhookUrl($postWebhookUrl)
    {
        $this->options['postWebhookUrl'] = $postWebhookUrl;
        return $this;
    }

    /**
     * The webhook_method
     *
     * @param string $webhookMethod The webhook_method
     *
     * @return $this Fluent Builder
     */
    public function setWebhookMethod($webhookMethod)
    {
        $this->options['webhookMethod'] = $webhookMethod;
        return $this;
    }

    /**
     * The webhook_filters
     *
     * @param string $webhookFilters The webhook_filters
     *
     * @return $this Fluent Builder
     */
    public function setWebhookFilters($webhookFilters)
    {
        $this->options['webhookFilters'] = $webhookFilters;
        return $this;
    }

    /**
     * The webhooks.on_message_send.url
     *
     * @param string $webhooksOnMessageSendUrl The webhooks.on_message_send.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageSendUrl($webhooksOnMessageSendUrl)
    {
        $this->options['webhooksOnMessageSendUrl'] = $webhooksOnMessageSendUrl;
        return $this;
    }

    /**
     * The webhooks.on_message_send.method
     *
     * @param string $webhooksOnMessageSendMethod The
     *                                            webhooks.on_message_send.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageSendMethod($webhooksOnMessageSendMethod)
    {
        $this->options['webhooksOnMessageSendMethod'] = $webhooksOnMessageSendMethod;
        return $this;
    }

    /**
     * The webhooks.on_message_send.format
     *
     * @param string $webhooksOnMessageSendFormat The
     *                                            webhooks.on_message_send.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageSendFormat($webhooksOnMessageSendFormat)
    {
        $this->options['webhooksOnMessageSendFormat'] = $webhooksOnMessageSendFormat;
        return $this;
    }

    /**
     * The webhooks.on_message_update.url
     *
     * @param string $webhooksOnMessageUpdateUrl The webhooks.on_message_update.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageUpdateUrl($webhooksOnMessageUpdateUrl)
    {
        $this->options['webhooksOnMessageUpdateUrl'] = $webhooksOnMessageUpdateUrl;
        return $this;
    }

    /**
     * The webhooks.on_message_update.method
     *
     * @param string $webhooksOnMessageUpdateMethod The
     *                                              webhooks.on_message_update.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageUpdateMethod($webhooksOnMessageUpdateMethod)
    {
        $this->options['webhooksOnMessageUpdateMethod'] = $webhooksOnMessageUpdateMethod;
        return $this;
    }

    /**
     * The webhooks.on_message_update.format
     *
     * @param string $webhooksOnMessageUpdateFormat The
     *                                              webhooks.on_message_update.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageUpdateFormat($webhooksOnMessageUpdateFormat)
    {
        $this->options['webhooksOnMessageUpdateFormat'] = $webhooksOnMessageUpdateFormat;
        return $this;
    }

    /**
     * The webhooks.on_message_remove.url
     *
     * @param string $webhooksOnMessageRemoveUrl The webhooks.on_message_remove.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageRemoveUrl($webhooksOnMessageRemoveUrl)
    {
        $this->options['webhooksOnMessageRemoveUrl'] = $webhooksOnMessageRemoveUrl;
        return $this;
    }

    /**
     * The webhooks.on_message_remove.method
     *
     * @param string $webhooksOnMessageRemoveMethod The
     *                                              webhooks.on_message_remove.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageRemoveMethod($webhooksOnMessageRemoveMethod)
    {
        $this->options['webhooksOnMessageRemoveMethod'] = $webhooksOnMessageRemoveMethod;
        return $this;
    }

    /**
     * The webhooks.on_message_remove.format
     *
     * @param string $webhooksOnMessageRemoveFormat The
     *                                              webhooks.on_message_remove.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageRemoveFormat($webhooksOnMessageRemoveFormat)
    {
        $this->options['webhooksOnMessageRemoveFormat'] = $webhooksOnMessageRemoveFormat;
        return $this;
    }

    /**
     * The webhooks.on_channel_add.url
     *
     * @param string $webhooksOnChannelAddUrl The webhooks.on_channel_add.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelAddUrl($webhooksOnChannelAddUrl)
    {
        $this->options['webhooksOnChannelAddUrl'] = $webhooksOnChannelAddUrl;
        return $this;
    }

    /**
     * The webhooks.on_channel_add.method
     *
     * @param string $webhooksOnChannelAddMethod The webhooks.on_channel_add.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelAddMethod($webhooksOnChannelAddMethod)
    {
        $this->options['webhooksOnChannelAddMethod'] = $webhooksOnChannelAddMethod;
        return $this;
    }

    /**
     * The webhooks.on_channel_add.format
     *
     * @param string $webhooksOnChannelAddFormat The webhooks.on_channel_add.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelAddFormat($webhooksOnChannelAddFormat)
    {
        $this->options['webhooksOnChannelAddFormat'] = $webhooksOnChannelAddFormat;
        return $this;
    }

    /**
     * The webhooks.on_channel_destroy.url
     *
     * @param string $webhooksOnChannelDestroyUrl The
     *                                            webhooks.on_channel_destroy.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelDestroyUrl($webhooksOnChannelDestroyUrl)
    {
        $this->options['webhooksOnChannelDestroyUrl'] = $webhooksOnChannelDestroyUrl;
        return $this;
    }

    /**
     * The webhooks.on_channel_destroy.method
     *
     * @param string $webhooksOnChannelDestroyMethod The
     *                                               webhooks.on_channel_destroy.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelDestroyMethod($webhooksOnChannelDestroyMethod)
    {
        $this->options['webhooksOnChannelDestroyMethod'] = $webhooksOnChannelDestroyMethod;
        return $this;
    }

    /**
     * The webhooks.on_channel_destroy.format
     *
     * @param string $webhooksOnChannelDestroyFormat The
     *                                               webhooks.on_channel_destroy.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelDestroyFormat($webhooksOnChannelDestroyFormat)
    {
        $this->options['webhooksOnChannelDestroyFormat'] = $webhooksOnChannelDestroyFormat;
        return $this;
    }

    /**
     * The webhooks.on_channel_update.url
     *
     * @param string $webhooksOnChannelUpdateUrl The webhooks.on_channel_update.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelUpdateUrl($webhooksOnChannelUpdateUrl)
    {
        $this->options['webhooksOnChannelUpdateUrl'] = $webhooksOnChannelUpdateUrl;
        return $this;
    }

    /**
     * The webhooks.on_channel_update.method
     *
     * @param string $webhooksOnChannelUpdateMethod The
     *                                              webhooks.on_channel_update.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelUpdateMethod($webhooksOnChannelUpdateMethod)
    {
        $this->options['webhooksOnChannelUpdateMethod'] = $webhooksOnChannelUpdateMethod;
        return $this;
    }

    /**
     * The webhooks.on_channel_update.format
     *
     * @param string $webhooksOnChannelUpdateFormat The
     *                                              webhooks.on_channel_update.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelUpdateFormat($webhooksOnChannelUpdateFormat)
    {
        $this->options['webhooksOnChannelUpdateFormat'] = $webhooksOnChannelUpdateFormat;
        return $this;
    }

    /**
     * The webhooks.on_member_add.url
     *
     * @param string $webhooksOnMemberAddUrl The webhooks.on_member_add.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberAddUrl($webhooksOnMemberAddUrl)
    {
        $this->options['webhooksOnMemberAddUrl'] = $webhooksOnMemberAddUrl;
        return $this;
    }

    /**
     * The webhooks.on_member_add.method
     *
     * @param string $webhooksOnMemberAddMethod The webhooks.on_member_add.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberAddMethod($webhooksOnMemberAddMethod)
    {
        $this->options['webhooksOnMemberAddMethod'] = $webhooksOnMemberAddMethod;
        return $this;
    }

    /**
     * The webhooks.on_member_add.format
     *
     * @param string $webhooksOnMemberAddFormat The webhooks.on_member_add.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberAddFormat($webhooksOnMemberAddFormat)
    {
        $this->options['webhooksOnMemberAddFormat'] = $webhooksOnMemberAddFormat;
        return $this;
    }

    /**
     * The webhooks.on_member_remove.url
     *
     * @param string $webhooksOnMemberRemoveUrl The webhooks.on_member_remove.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberRemoveUrl($webhooksOnMemberRemoveUrl)
    {
        $this->options['webhooksOnMemberRemoveUrl'] = $webhooksOnMemberRemoveUrl;
        return $this;
    }

    /**
     * The webhooks.on_member_remove.method
     *
     * @param string $webhooksOnMemberRemoveMethod The
     *                                             webhooks.on_member_remove.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberRemoveMethod($webhooksOnMemberRemoveMethod)
    {
        $this->options['webhooksOnMemberRemoveMethod'] = $webhooksOnMemberRemoveMethod;
        return $this;
    }

    /**
     * The webhooks.on_member_remove.format
     *
     * @param string $webhooksOnMemberRemoveFormat The
     *                                             webhooks.on_member_remove.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberRemoveFormat($webhooksOnMemberRemoveFormat)
    {
        $this->options['webhooksOnMemberRemoveFormat'] = $webhooksOnMemberRemoveFormat;
        return $this;
    }

    /**
     * The webhooks.on_message_sent.url
     *
     * @param string $webhooksOnMessageSentUrl The webhooks.on_message_sent.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageSentUrl($webhooksOnMessageSentUrl)
    {
        $this->options['webhooksOnMessageSentUrl'] = $webhooksOnMessageSentUrl;
        return $this;
    }

    /**
     * The webhooks.on_message_sent.method
     *
     * @param string $webhooksOnMessageSentMethod The
     *                                            webhooks.on_message_sent.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageSentMethod($webhooksOnMessageSentMethod)
    {
        $this->options['webhooksOnMessageSentMethod'] = $webhooksOnMessageSentMethod;
        return $this;
    }

    /**
     * The webhooks.on_message_sent.format
     *
     * @param string $webhooksOnMessageSentFormat The
     *                                            webhooks.on_message_sent.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageSentFormat($webhooksOnMessageSentFormat)
    {
        $this->options['webhooksOnMessageSentFormat'] = $webhooksOnMessageSentFormat;
        return $this;
    }

    /**
     * The webhooks.on_message_updated.url
     *
     * @param string $webhooksOnMessageUpdatedUrl The
     *                                            webhooks.on_message_updated.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageUpdatedUrl($webhooksOnMessageUpdatedUrl)
    {
        $this->options['webhooksOnMessageUpdatedUrl'] = $webhooksOnMessageUpdatedUrl;
        return $this;
    }

    /**
     * The webhooks.on_message_updated.method
     *
     * @param string $webhooksOnMessageUpdatedMethod The
     *                                               webhooks.on_message_updated.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageUpdatedMethod($webhooksOnMessageUpdatedMethod)
    {
        $this->options['webhooksOnMessageUpdatedMethod'] = $webhooksOnMessageUpdatedMethod;
        return $this;
    }

    /**
     * The webhooks.on_message_updated.format
     *
     * @param string $webhooksOnMessageUpdatedFormat The
     *                                               webhooks.on_message_updated.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageUpdatedFormat($webhooksOnMessageUpdatedFormat)
    {
        $this->options['webhooksOnMessageUpdatedFormat'] = $webhooksOnMessageUpdatedFormat;
        return $this;
    }

    /**
     * The webhooks.on_message_removed.url
     *
     * @param string $webhooksOnMessageRemovedUrl The
     *                                            webhooks.on_message_removed.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageRemovedUrl($webhooksOnMessageRemovedUrl)
    {
        $this->options['webhooksOnMessageRemovedUrl'] = $webhooksOnMessageRemovedUrl;
        return $this;
    }

    /**
     * The webhooks.on_message_removed.method
     *
     * @param string $webhooksOnMessageRemovedMethod The
     *                                               webhooks.on_message_removed.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageRemovedMethod($webhooksOnMessageRemovedMethod)
    {
        $this->options['webhooksOnMessageRemovedMethod'] = $webhooksOnMessageRemovedMethod;
        return $this;
    }

    /**
     * The webhooks.on_message_removed.format
     *
     * @param string $webhooksOnMessageRemovedFormat The
     *                                               webhooks.on_message_removed.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMessageRemovedFormat($webhooksOnMessageRemovedFormat)
    {
        $this->options['webhooksOnMessageRemovedFormat'] = $webhooksOnMessageRemovedFormat;
        return $this;
    }

    /**
     * The webhooks.on_channel_added.url
     *
     * @param string $webhooksOnChannelAddedUrl The webhooks.on_channel_added.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelAddedUrl($webhooksOnChannelAddedUrl)
    {
        $this->options['webhooksOnChannelAddedUrl'] = $webhooksOnChannelAddedUrl;
        return $this;
    }

    /**
     * The webhooks.on_channel_added.method
     *
     * @param string $webhooksOnChannelAddedMethod The
     *                                             webhooks.on_channel_added.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelAddedMethod($webhooksOnChannelAddedMethod)
    {
        $this->options['webhooksOnChannelAddedMethod'] = $webhooksOnChannelAddedMethod;
        return $this;
    }

    /**
     * The webhooks.on_channel_added.format
     *
     * @param string $webhooksOnChannelAddedFormat The
     *                                             webhooks.on_channel_added.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelAddedFormat($webhooksOnChannelAddedFormat)
    {
        $this->options['webhooksOnChannelAddedFormat'] = $webhooksOnChannelAddedFormat;
        return $this;
    }

    /**
     * The webhooks.on_channel_destroyed.url
     *
     * @param string $webhooksOnChannelDestroyedUrl The
     *                                              webhooks.on_channel_destroyed.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelDestroyedUrl($webhooksOnChannelDestroyedUrl)
    {
        $this->options['webhooksOnChannelDestroyedUrl'] = $webhooksOnChannelDestroyedUrl;
        return $this;
    }

    /**
     * The webhooks.on_channel_destroyed.method
     *
     * @param string $webhooksOnChannelDestroyedMethod The
     *                                                 webhooks.on_channel_destroyed.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelDestroyedMethod($webhooksOnChannelDestroyedMethod)
    {
        $this->options['webhooksOnChannelDestroyedMethod'] = $webhooksOnChannelDestroyedMethod;
        return $this;
    }

    /**
     * The webhooks.on_channel_destroyed.format
     *
     * @param string $webhooksOnChannelDestroyedFormat The
     *                                                 webhooks.on_channel_destroyed.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelDestroyedFormat($webhooksOnChannelDestroyedFormat)
    {
        $this->options['webhooksOnChannelDestroyedFormat'] = $webhooksOnChannelDestroyedFormat;
        return $this;
    }

    /**
     * The webhooks.on_channel_updated.url
     *
     * @param string $webhooksOnChannelUpdatedUrl The
     *                                            webhooks.on_channel_updated.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelUpdatedUrl($webhooksOnChannelUpdatedUrl)
    {
        $this->options['webhooksOnChannelUpdatedUrl'] = $webhooksOnChannelUpdatedUrl;
        return $this;
    }

    /**
     * The webhooks.on_channel_updated.method
     *
     * @param string $webhooksOnChannelUpdatedMethod The
     *                                               webhooks.on_channel_updated.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelUpdatedMethod($webhooksOnChannelUpdatedMethod)
    {
        $this->options['webhooksOnChannelUpdatedMethod'] = $webhooksOnChannelUpdatedMethod;
        return $this;
    }

    /**
     * The webhooks.on_channel_updated.format
     *
     * @param string $webhooksOnChannelUpdatedFormat The
     *                                               webhooks.on_channel_updated.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnChannelUpdatedFormat($webhooksOnChannelUpdatedFormat)
    {
        $this->options['webhooksOnChannelUpdatedFormat'] = $webhooksOnChannelUpdatedFormat;
        return $this;
    }

    /**
     * The webhooks.on_member_added.url
     *
     * @param string $webhooksOnMemberAddedUrl The webhooks.on_member_added.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberAddedUrl($webhooksOnMemberAddedUrl)
    {
        $this->options['webhooksOnMemberAddedUrl'] = $webhooksOnMemberAddedUrl;
        return $this;
    }

    /**
     * The webhooks.on_member_added.method
     *
     * @param string $webhooksOnMemberAddedMethod The
     *                                            webhooks.on_member_added.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberAddedMethod($webhooksOnMemberAddedMethod)
    {
        $this->options['webhooksOnMemberAddedMethod'] = $webhooksOnMemberAddedMethod;
        return $this;
    }

    /**
     * The webhooks.on_member_added.format
     *
     * @param string $webhooksOnMemberAddedFormat The
     *                                            webhooks.on_member_added.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberAddedFormat($webhooksOnMemberAddedFormat)
    {
        $this->options['webhooksOnMemberAddedFormat'] = $webhooksOnMemberAddedFormat;
        return $this;
    }

    /**
     * The webhooks.on_member_removed.url
     *
     * @param string $webhooksOnMemberRemovedUrl The webhooks.on_member_removed.url
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberRemovedUrl($webhooksOnMemberRemovedUrl)
    {
        $this->options['webhooksOnMemberRemovedUrl'] = $webhooksOnMemberRemovedUrl;
        return $this;
    }

    /**
     * The webhooks.on_member_removed.method
     *
     * @param string $webhooksOnMemberRemovedMethod The
     *                                              webhooks.on_member_removed.method
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberRemovedMethod($webhooksOnMemberRemovedMethod)
    {
        $this->options['webhooksOnMemberRemovedMethod'] = $webhooksOnMemberRemovedMethod;
        return $this;
    }

    /**
     * The webhooks.on_member_removed.format
     *
     * @param string $webhooksOnMemberRemovedFormat The
     *                                              webhooks.on_member_removed.format
     *
     * @return $this Fluent Builder
     */
    public function setWebhooksOnMemberRemovedFormat($webhooksOnMemberRemovedFormat)
    {
        $this->options['webhooksOnMemberRemovedFormat'] = $webhooksOnMemberRemovedFormat;
        return $this;
    }

    /**
     * The limits.channel_members
     *
     * @param integer $limitsChannelMembers The limits.channel_members
     *
     * @return $this Fluent Builder
     */
    public function setLimitsChannelMembers($limitsChannelMembers)
    {
        $this->options['limitsChannelMembers'] = $limitsChannelMembers;
        return $this;
    }

    /**
     * The limits.user_channels
     *
     * @param integer $limitsUserChannels The limits.user_channels
     *
     * @return $this Fluent Builder
     */
    public function setLimitsUserChannels($limitsUserChannels)
    {
        $this->options['limitsUserChannels'] = $limitsUserChannels;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.IpMessaging.V1.UpdateServiceOptions '.implode(' ', $options).']';
    }
}