<p align="center">
  <a href="https://www.abantecart.com">
    <img src="https://www.abantecart.com/resources/image/18/7c/8.png" alt="AbanteCart Logo" width="300">
  </a>
</p>

<p align="center">
  <a href="https://github.com/abantecart/abantecart-src/blob/master/LICENSE.txt"><img src="https://img.shields.io/badge/license-OSL%203.0-blue.svg" alt="License"></a>
  <a href="https://github.com/abantecart/abantecart-src/releases"><img src="https://img.shields.io/github/v/release/abantecart/abantecart-src" alt="Release Version"></a>
  <a href="https://github.com/abantecart/abantecart-src/issues"><img src="https://img.shields.io/github/issues/abantecart/abantecart-src.svg" alt="Issues"></a>
</p>

---

## 🚀 Overview

**AbanteCart** is a free and open-source eCommerce platform designed to power modern online retail and digital commerce. Whether you're launching your first store or developing a complex eCommerce solution, AbanteCart offers a robust and extensible foundation.

- 🧩 Modular, extensible architecture  
- ⚡ Lightweight, fast, and secure  
- 📦 Rich feature set with a user-friendly admin interface  
- 🎯 Built for developers and business owners  

👉 Explore the [Live Demo](https://www.abantecart.com/shopping-cart-demo)  
👉 Learn more at [abantecart.com](https://www.abantecart.com)

---

## 📦 Getting Started

### ✅ Requirements

- PHP 8.2.x  
- MySQL 8.0+ or MariaDB 10.5+  
- Apache or Nginx  
- `mod_rewrite` enabled  

### 🛠️ Installation

1. Clone the repository:
   ```bash
   git clone https://github.com/abantecart/abantecart-src.git
   ```

2. Web installation
   ```
   Place contents of `/public_html` in your web root directory.
   Open your browser and navigate to:
       http://localhost/abantecart-src/public_html/
   Follow the web installer instructions.
   ```
3. or CLI installation:
   ```
   cd /path/server/htdocs/
   php ./install/cli_install.php install --db_host=127.0.0.1 --db_user=**** --db_password=**** --db_name=****  --db_driver=amysqli  --db_prefix=abc_ --admin_path=admin  --username=admin  --password=admin  --email=admin@admin.com  --http_server=https://your_domain/ --with-sample-data=abantecart_sample_data.sql
   ``` 

📚 Detailed instructions: [Installation Guide](https://abantecart.atlassian.net/wiki/spaces/AD/pages/4292610/Installation)

---

## 🧠 Documentation

- 📖 [Developer Docs](https://docs.abantecart.com)  
- 💡 [Community Forum](https://forum.abantecart.com)  
- 🧩 [Extension Marketplace](https://marketplace.abantecart.com)

---

## 🐞 Reporting Issues

Before submitting an issue, please:

1. Search the [AbanteCart forum](https://forum.abantecart.com)  
2. Check [existing GitHub issues](https://github.com/abantecart/abantecart-src/issues)  
3. Review the [changelog](https://github.com/abantecart/abantecart-src/blob/master/release_notes.txt)  
4. Confirm it’s not an issue with your hosting/server environment  

> ❗ **Security Issues**  
> Please do **not** post security issues publicly. Contact a moderator privately via the [AbanteCart site](https://www.abantecart.com/index.php?rt=content/contact).

---

## 💡 Suggest Features

Have an idea or enhancement in mind?  
Share your suggestions on our [Community Forum](https://forum.abantecart.com/index.php/board,25.0.html).

---

## 🤝 Contributing

We welcome contributions! Follow these steps:

1. Fork the repo  
2. Create a feature branch  
3. Submit a pull request to the appropriate development branch  

📌 Please follow PHP [coding standards](https://www.php-fig.org/psr/psr-12/) and include meaningful commit messages.

---

## 🔢 Versioning

AbanteCart uses **four-part versioning**: `MAJOR.MINOR.BUILD.REVISION`

- `MAJOR` – Breaking changes or complete rewrites  
- `MINOR` – Significant changes to core  
- `BUILD` – New features (safe upgrade path)  
- `REVISION` – Bug fixes (safe for all)

---

## 📢 Releases

- Stay updated by subscribing to our newsletter on [abantecart.com](https://www.abantecart.com) (footer).

---

## 📜 License

Distributed under the [Open Software License (OSL 3.0)](https://opensource.org/licenses/OSL-3.0).

---

## 🔗 Useful Links

- 🌐 [Official Website](https://www.abantecart.com)  
- 📘 [Documentation](https://docs.abantecart.com)  
- 🧩 [Extension Marketplace](https://marketplace.abantecart.com)  
- 🗣️ [Community Forum](https://forum.abantecart.com)  
- 🎥 [YouTube Tutorials](https://www.youtube.com/@abantecart/videos)

---

## ❤️ Made With Passion

AbanteCart is maintained by a passionate team of developers and contributors.  
Help us build the future of open-source commerce! 

---